﻿' “文件打开选取器合同”项模板在 http://go.microsoft.com/fwlink/?LinkId=234239 上提供

''' <summary>
''' 此页显示该应用程序拥有的文件，以便用户可以授权其他应用程序
''' 访问这些文件。
''' </summary>
Public NotInheritable Class $safeitemname$
    Inherits Page

    ''' <summary>
    ''' 可将其更改为强类型视图模型。
    ''' </summary>
    Public ReadOnly Property DefaultViewModel As Common.ObservableDictionary
        Get
            Return Me._defaultViewModel
        End Get
    End Property
    Private _defaultViewModel As New Common.ObservableDictionary()

    ''' <summary>
    ''' 在 Windows UI 中添加或移除文件以让 Windows 知道已选定的内容。
    ''' </summary>
    Private _fileOpenPickerUI As Windows.Storage.Pickers.Provider.FileOpenPickerUI

    Public Sub New()
        InitializeComponent()
        AddHandler Window.Current.SizeChanged, AddressOf Winow_SizeChanged
        InvalidateVisualState()
    End Sub

    ''' <summary>
    ''' 在 Window 改变大小时调用
    ''' </summary>
    ''' <param name="sender">当前的 Window</param>
    ''' <param name="e">描述 Window 新大小的事件数据</param>
    Private Sub Winow_SizeChanged(sender As Object, e As Windows.UI.Core.WindowSizeChangedEventArgs)
        Me.InvalidateVisualState()
    End Sub


    Private Sub InvalidateVisualState()
        Dim visualState As String = DetermineVisualState()
        VisualStateManager.GoToState(Me, visualState, False)
    End Sub

    ''' <summary>
    ''' 调用以判断对应于应用程序视图状态的可视状态
    ''' 的名称。
    ''' </summary>
    ''' <returns>所需的可视状态的名称。此名称与视图状态的名称相同，
    ''' 但在通过添加 _Detail 后缀表示此附加逻辑页的纵向和对齐视图中
    ''' 有所选的项时除外。</returns>
    Private Function DetermineVisualState() As String

        If Window.Current.Bounds.Width >= 500 Then
            Return "HorizontalView"
        Else
            Return "VerticalView"
        End If

    End Function


    ''' <summary>
    ''' 在其他应用程序想要打开此应用程序中的文件时进行调用。
    ''' </summary>
    ''' <param name="e">用于与 Windows 协调进程的激活数据。</param>
    Public Sub Activate(e As FileOpenPickerActivatedEventArgs)
        Me._fileOpenPickerUI = e.FileOpenPickerUI
        AddHandler CType(Me._fileOpenPickerUI, Windows.Storage.Pickers.Provider.FileOpenPickerUI).FileRemoved, AddressOf Me.FilePickerUI_FileRemoved

        ' TODO:  设置 Me.DefaultViewModel("Files") 以显示一个项集合，
        '       其中的每个项都应有可绑定的 Image、Title 和 Description

        Me.DefaultViewModel("CanGoUp") = False
        Window.Current.Content = Me
        Window.Current.Activate()
    End Sub

    ''' <summary>
    ''' 当用户从选取器框中移除某一项目时调用
    ''' </summary>
    ''' <param name="sender">用于包含可用文件的 FileOpenPickerUI 实例。</param>
    ''' <param name="e">描述已移除文件的事件数据。</param>
    Private Sub FilePickerUI_FileRemoved(sender As Windows.Storage.Pickers.Provider.FileOpenPickerUI, e As Windows.Storage.Pickers.Provider.FileRemovedEventArgs)
        ' TODO:  响应在选取器 UI 中取消选择的项。
    End Sub

    ''' <summary>
    ''' 在选定的文件集合发生更改时进行调用。
    ''' </summary>
    ''' <param name="sender">用于显示可用文件的 GridView 实例。</param>
    ''' <param name="e">描述所选内容如何发生变化的事件数据。</param>
    Private Sub FileGridView_SelectionChanged(sender As Object, e As SelectionChangedEventArgs)

        ' TODO:  使用 Me._fileOpenPickerUI.AddFile 和 Me._fileOpenPickerUI.RemoveFile
        '       更新 Windows UI

    End Sub

    ''' <summary>
    ''' 在单击“转到上级”按钮时进行调用，并指示用户希望在文件
    ''' 的层次结构中提升一个级别。
    ''' </summary>
    ''' <param name="sender">用于表示“Go up”命令的 Button 实例。</param>
    ''' <param name="e">描述如何单击按钮的事件数据。</param>
    Private Sub GoUpButton_Click(sender As Object, e As RoutedEventArgs)

        ' TODO:  将 Me.DefaultViewModel("CanGoUp") 设置为 true 以启用对应的命令，
        '       使用 Me.DefaultViewModel("Files") 的更新以反映文件层次结构遍历

    End Sub

End Class
